--[[

CMD Marathon Soccer v1.4 (091005)
by DJ Command 

http://cmdplus.tuzikaze.com/
http://www.s-a-r.jp/
dj-command@y3.dion.ne.jp

]]

---------------- グローバル変数定義 ----------------

CollectionsUsed = {1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31}
Triggers, Vec2D, VALIDSIDES = {}, {}, {}
TEAM_A, TEAM_B = "red", "blue"
BALLOUTSIDE, GOALED, OFFSIDEGK, ISSINGLEGAME = false, false, false, false, false
BALL, CATCHEDPLYR, KICKEDPLYR, KICKOFFPLYR = nil, nil, nil, nil
FIRST, INTERRUPT, KICKOFF = false, false, false
WAITTIME = 0
B_ISGND = false
B_HEIGHT = 0
B_ANGL = 0
B_VELO, B_GRAV, B_ROTV = 0, 0, 0
B_XPOS, B_YPOS, B_ZPOS, B_PPOS = 0, 0, 0, nil
B_XOLD, B_YOLD, B_ZOLD, B_POLD = 0, 0, 0, nil
B_XINT, B_YINT, B_ZINT, B_PINT = 0, 0, 0, nil
B_XLND, B_YLND, B_ZLND, B_PLND = 0, 0, 0, nil

---------------- 物理定数 ----------------

CNST_gravity 		= 0.020	----重力係数(WU)
CNST_elasticpwr 	= 0.750	----弾性係数(%)
CNST_frictiongnd	= 0.012	----ボール地面摩擦係数(WU)
CNST_frictionair	= 0.007	----ボール空気摩擦係数(WU)
CNST_frictionrot	= 0.125 ----ボール回転減速係数(DEG)
CNST_kickpwr1st		= 0.400	----通常シュート力(WU)
CNST_kickpwr2nd		= 0.900	----パワーシュート力(WU)
CNST_driblepwr		= 0.100	----ドリブル力(WU)
CNST_drblarea		= 0.750	----ドリブルエリア半径(WU)
CNST_shotarea		= 3.000	----シュートエリア半径(WU)
CNST_rotatevelo		=    25	----プレイヤー回転力補正(scale)
CNST_ballsize		= 0.125	----ボールサイズ半径(WU)
CNST_wallbound		= 0.600	----壁反射係数(WU)
CNST_dashspdmax		=25.000	----ダッシュ最高速度(WU)
CNST_dashspd		= 8.000	----ダッシュ速度(WU)
CNST_jumppwr		=16.000	----ジャンプパワー(WU)
CNST_oxygendrain	=   982	----イベント消費酸素(MAX:10800)
CNST_oxygenrecover	=    20 ----酸素回復量(MAX:10800)
--[[
•••••••••••••••••••••••••••••••••••••••••••••••••••••••••••••••
•••••••••••••••••••••••••••• 関数定義 •••••••••••••••••••••••••••
•••••••••••••••••••••••••••••••••••••••••••••••••••••••••••••••
]]


function FIXDEG(deg) ---- 角度修正関数
	if deg > 180 then deg = deg - (360 * math.floor(deg / 360))
	elseif deg < -180 then deg = (360 * math.floor(deg / 360)) + deg end
	return deg
end

function FINDPOLYGON(x, y, z) ---- 指定座標を含むポリゴンの検出関数
	for g in Polygons() do
		if g:contains(x, y, z + 0.010) then return g end
	end
end

function FINDNEARESTPLYR() ---- 指定チームのボールに一番近いプレイヤーの検出関数
	local dist, shortest, i, team = 0, 1024, nil, nil
	if KICKEDPLYR.team == TEAM_A then team = TEAM_B
	else team = TEAM_A end
	
	for p in Players() do
		dist = ((p.x - B_XLND) ^ 2 + (p.y - B_YLND) ^ 2) ^ 0.5
		if (dist < shortest and p.team == team) then
			shortest = dist
			i = p
		end
	end
	if ISSINGLEGAME then i = Players[0] end
	return i
end

-------------- Vector Tools v1.0 --------------

function Vec2D.new(x, y) --ベクトル計算：新規定義
	local t = {}
	t.x, t.y = x, y
	return t
end

function Vec2D.add(v1, v2) --ベクトル計算：加算
	local t = {}
	t.x, t.y = (v1.x + v2.x), (v1.y + v2.y)
	return t
end

function Vec2D.sub(v1, v2) --ベクトル計算：減算
	local t = {}
	t.x, t.y = (v1.x - v2.x), (v1.y - v2.y)
	return t
end

function Vec2D.scale(v, s) --ベクトル計算：掛算（スケール倍）
	local t = {}
	t.x, t.y = (v.x * s), (v.y * s)
	return t
end

function Vec2D.size(v) --ベクトル計算：大きさ（長さ）計算
	local i = math.sqrt(v.x ^ 2 + v.y ^ 2)
	return i
end

function Vec2D.dot(v1, v2) --ベクトル計算：内積
	local i = (v1.x * v2.x) + (v1.y * v2.y)
	return i
end

function Vec2D.perp(v) --ベクトル計算：法線化（90度+）
	local t = {}
	t.x, t.y = -v.y, v.x 
	return t
end

function Vec2D.norm(v) --ベクトル計算：正規化（ノーマライズ）
	local len, t = (v.x ^ 2 + v.y ^ 2) ^ 0.5, {}
	if len > 0 then len = 1 / len end
	t.x, t.y = v.x * len, v.y * len
	return t
end


--[[
•••••••••••••••••••••••••••••••••••••••••••••••••••••••••••••••
•••••••••••••••••••••••••• サブルーチン群 •••••••••••••••••••••••••
•••••••••••••••••••••••••••••••••••••••••••••••••••••••••••••••
]]


--================ フィールド・設定のリセット ================--


function RESETFIELD()
	for p in Players() do
		p:fade_screen("white")
		p:play_sound("teleport in")
		p.oxygen = 10800
		p.external_velocity.x, p.external_velocity.y, p.external_velocity.z = 0, 0, 0
		p.compass.x, p.compass.y = 0, 0
		p:position(p._STX, p._STY, p._STZ, p._STP)
		p._OLDX, p._OLDY, p._OLDZ, p._OLDP = p.x, p.y, p.z, p.polygon
		p.yaw = FIXDEG(180 + math.deg(math.atan2(p._STY, p._STX)))
		p.pitch = 0
		p._SHOTMODE, p._RELOADTIME, p._TXTRELEASE = 0, 0, 0
		p._COLLISIONED = false
		p._ROTATEVELO = 0
		p._OLDYAW = p.yaw
	end
	B_ISGND = false
	B_XPOS, B_YPOS, B_ZPOS = B_XINT, B_YINT, B_ZINT
	B_VELO, B_GRAV, B_ROTV = 0, 0, 0
	CATCHEDPLYR, KICKOFFPLYR, BALLOUTSIDE, GOALED, OFFSIDEGK = nil, nil, false, false, false
	BALL:position(B_XINT, B_YINT, B_ZINT, B_PINT)
end


--================ ボールの処理 ================--


function BALLBOUNCE()
	local n, s, c, ac, bc = {}, {}, {}, {}, {}
	local x, y, l, d, t, radius
	local g = nil
	
	if B_ISGND then														--ボールが接地していたら
		B_VELO = B_VELO - CNST_frictiongnd
	else																--ボールが空中飛行していたら
		B_VELO = B_VELO - CNST_frictionair
		if CATCHEDPLYR == nil then										--Z軸加速度に重力加速度を加算
			B_GRAV = B_GRAV - CNST_gravity
		end
	end
	
	if B_ROTV > 0 then
		B_ROTV = math.min(20, math.max(0, B_ROTV - CNST_frictionrot))
	elseif B_ROTV < 0 then
		B_ROTV = math.max(-20, math.min(0, B_ROTV + CNST_frictionrot))
	end
	B_ANGL = FIXDEG(B_ANGL + B_ROTV)
	
	B_XOLD, B_YOLD, B_ZOLD, B_POLD = B_XPOS, B_YPOS, B_ZPOS, B_PPOS		--ボールの旧座標を設定
	
	t = math.rad(B_ANGL)
	B_VELO = math.max(0, B_VELO)
	B_XPOS = B_XPOS + math.cos(t) * B_VELO								--ボールX座標にX軸加速度を加算
	B_YPOS = B_YPOS + math.sin(t) * B_VELO								--ボールY座標にY軸加速度を加算
	B_ZPOS = B_ZPOS + B_GRAV											--ボールZ座標にZ軸加速度を加算
	
	if B_ISGND == false and B_ZPOS < BALL.polygon.floor.z then			--ボールが地面についたならば
		B_ZPOS = BALL.polygon.floor.z										--ボール位置を地面に戻す
		if math.abs(B_GRAV) < 0.050 then									--バウンド力が０に近づいたら
			B_ISGND = true														--接地フラグON
			B_GRAV = 0															--重力加速度を０にする
			B_HEIGHT = BALL.polygon.floor.z
		else																--まだ弾く場合は
			B_GRAV = -B_GRAV * CNST_elasticpwr									--弾性力%で跳ね返る
			BALL:play_sound("ball bounce")										--「ボヨン」
		end
	elseif B_ISGND and B_HEIGHT > BALL.polygon.floor.z then				--穴に落ちた場合
		B_ISGND = false														--接地フラグOFF
		B_GRAV = -0.050														--落下速度をつける
	end
	
	if B_ZPOS > BALL.polygon.ceiling.z - CNST_ballsize then				--ボールが天井についたならば
		B_ZPOS = BALL.polygon.ceiling.z - CNST_ballsize						--ボール位置を地面に戻す
		B_GRAV = -B_GRAV													--跳ね返る
		BALL:play_sound("ball bounce")										--「ボヨン」
	end
	
	for w = 1, #VALIDSIDES do											--壁のベクトル反射処理
		l = VALIDSIDES[w].line
		
		if B_ZPOS + B_GRAV < l.highest_adjacent_floor or B_ZPOS + B_GRAV > l.lowest_adjacent_ceiling or l.solid then 
			s = Vec2D.new(l.endpoints[1].x - l.endpoints[0].x, l.endpoints[1].y - l.endpoints[0].y)
			n = Vec2D.new(s.x, s.y)
			n = Vec2D.norm(n)
			n = Vec2D.perp(n)
			radius = CNST_ballsize + B_VELO
			s.x = -n.x * radius
			s.y = -n.y * radius
			d = - (l.endpoints[0].x * n.x + l.endpoints[0].y * n.y)
			t = - (n.x * B_XPOS + n.y * B_YPOS + d) / (n.x * s.x + n.y * s.y)
			
			if t > 0 and t <= 1 then
				c = Vec2D.new(B_XPOS + t * s.x, B_YPOS + t * s.y)
				ac = Vec2D.new(c.x - l.endpoints[0].x, c.y - l.endpoints[0].y)
				bc = Vec2D.new(c.x - l.endpoints[1].x, c.y - l.endpoints[1].y)
				
				if Vec2D.dot(ac,bc) < 0 then
					if (VALIDSIDES[w]._ISGOALWALL ~= nil) and (GOALED == false) and (CATCHEDPLYR == nil) and (INTERRUPT == false) then 
						GOALED = true
						INTERRUPT = true
						SOCCEREVENT()
					end
					
					B_XPOS = c.x + radius * n.x
					B_YPOS = c.y + radius * n.y
					
					if FINDPOLYGON(B_XPOS, B_YPOS, B_ZPOS) == nil then	----ベクトルが反時計回りだと逆転するので、ここで検査
						B_XPOS = c.x + radius * -n.x
						B_YPOS = c.y + radius * -n.y
					end
					
					B_VELO = B_VELO * CNST_wallbound
					d = math.rad(B_ANGL)
					x = math.cos(d) * B_VELO
					y = math.sin(d) * B_VELO
					t = -(s.x * x + s.y * y) / (s.x ^ 2 + s.y ^ 2)
					x = x + t * s.x * 2
					y = y + t * s.y * 2
					
					B_ANGL = FIXDEG(math.deg(math.atan2(y, x)))
					
					B_ROTV = 0
					BALL:play_sound("ball bounce")
				end
			end
		end
	end
	
	B_PPOS = FINDPOLYGON(B_XPOS, B_YPOS, B_ZPOS)					--移動予定先座標のポリゴンを検出
	if B_PPOS ~= nil then
		BALL:position(B_XPOS, B_YPOS, B_ZPOS, B_PPOS)					--ボールの位置を設定
	end
end


--================ ゴール・サッカーイベント ================--


function SOCCEREVENT()
	local b, own = false, false
	
	if BALL.polygon.type == "item impassable" and B_ZPOS <= BALL.polygon.floor.z and BALLOUTSIDE == false then	----タッチライン越え
		B_XLND, B_YLND, B_ZLND, B_PLND = B_XPOS, B_YPOS, B_ZPOS, B_PPOS
		BALLOUTSIDE = true
		INTERRUPT = true
		return
	end
	
	if GOALED then																		----ゴール！
		if (KICKEDPLYR.team == TEAM_A and BALL.y < 0) or (KICKEDPLYR.team == TEAM_B and BALL.y > 0) then
			own = false
		else																			----オウンゴール。。。
			own = true
		end
		
		for p in Players() do
		
			if (KICKEDPLYR == p) then													----ゴールしたプレイヤー
			
				if own == false then
					p:play_sound("you are it",1)
					p:play_sound("got powerup",1)
					p:fade_screen("bonus")
					p.overlays[0].text = "GOAL!! You scored a goal!!"
					p.external_velocity.z = CNST_jumppwr
					if ISSINGLEGAME == false then p.points = p.points + 1 end
				else
					p:play_sound("suffocation",1)
					p.overlays[0].text = "OWN GOAL!! What are you doing!?"
					p:fade_screen("big red")
				end
				
			elseif (p.team == KICKEDPLYR.team) then										----ゴールしたプレイヤーのチームメンバー達
			
				if own == false then
					p.overlays[0].text = "GOAL!! ".. KICKEDPLYR.name .." of your team scored a goal!"
					p.external_velocity.z = CNST_jumppwr
					p:fade_screen("bonus")
				else
					p:play_sound("suffocation",1)
					p:fade_screen("big red")
					p.overlays[0].text = "OWN GOAL!! ".. KICKEDPLYR.name .." made the mistake!"
				end
				
			else																		----敵陣メンバー達
			
				if own == false then
					p:play_sound("suffocation",1)
					p.overlays[0].text = "Enemy team was reached!!"
					p:fade_screen("big red")
				else
					p:play_sound("you are it",1)
					p.overlays[0].text = "Enemy team was OWN GOAL!! Somebody of yours gets 1 points."
					p.external_velocity.z = CNST_jumppwr
					p:fade_screen("bonus")
					if ISSINGLEGAME == false and b == false then
						b = true
						p.points = p.points + 1
					end
				end
				
			end
			
			p._TXTRELEASE = 80
		end
	end
end


--================ ドリブル・シュート処理 ================--


function SHOOTING(p)
	local i, pspd, pw, dist, deg, x, y
	local touch, stop = false, false
	local pdeg, blds = {}, {}
	
	if p == CATCHEDPLYR then												----プレイヤーがボールを抱えている場合
		B_XPOS, B_YPOS, B_ZPOS = p.x, p.y, p.z
		B_VELO = 0.750
		B_ANGL = p.yaw
		B_GRAV = 0.600 + math.sin(math.rad(p.pitch)) * 0.600
		if (p.polygon.type ~= "zone border" and BALLOUTSIDE == false) then	----GKエリア以外に出てしまったら
			i = math.rad(B_ANGL)
			B_XPOS = p.x + math.cos(i) * B_VELO
			B_YPOS = p.y + math.sin(i) * B_VELO
			B_ZPOS = p.z + B_GRAV
			B_VELO, B_GRAV = 0, 0
			CATCHEDPLYR = nil												----ボール所持解除
			B_ISGND = false													----ボール離陸
			B_GRAV = 0.100													----ちょっと浮き上がらせる
		end 
		
		if (p._SHOTMODE > 0) then											----キックしたら
			i = math.rad(B_ANGL)
			B_XPOS = p.x + math.cos(i) * B_VELO
			B_YPOS = p.y + math.sin(i) * B_VELO
			B_ZPOS = p.z + B_GRAV
			B_VELO, B_GRAV = 0, 0
			BALLOUTSIDE = false												----スローインモード解除
			CATCHEDPLYR = nil												----ボール所持解除
			SHOOTING(p)														----もう一度ルーチンを呼び戻す
		end
		
	elseif (CATCHEDPLYR == nil) then										---- 誰もボールを抱えていなかった場合
	
		dist = (p.x - B_XPOS) ^ 2 + (p.y - B_YPOS) ^ 2 + (p.z - B_ZPOS) ^ 2 ----ボールとプレイヤーとの距離（３次元）
		
		if dist < CNST_shotarea and p._SHOTMODE > 0 then					----距離がシュート可能距離で発射キーが押されたらならば
			if p._SHOTMODE == 1 then										----シュート
				pw = CNST_kickpwr1st
			elseif p._SHOTMODE == 2 then									----ロングシュート
				pw = CNST_kickpwr2nd
			end
			touch = true
			B_ROTV = p._ROTATEVELO
			BALL:play_sound("fist hitting", 0)
		elseif (dist < CNST_drblarea) then									----距離がドリブル可能距離ならば
			pspd = ((p._OLDX - p.x) ^ 2 + (p._OLDY - p.y) ^ 2) ^ 0.5		----自分の加速度検出
			if (pspd > 0.050) then											----加速度があった場合はドリブルする
				BALL:play_sound("flickta melee hit", 0)
			else															----加速度がない場合は受け止める
				stop = true
			end
			touch = true
			pw = CNST_driblepwr
			x, y = p.x - B_XPOS, p.y - B_YPOS
			deg = (x ^ 2 + y ^ 2) ^ 0.5										----ボールとプレイヤーとの距離（２次元）
			B_VELO = (CNST_drblarea - dist) / 2					----ドリブル可能距離にめり込んだ距離
		end
		
		if touch then														----ドリブルもしくはシュートしたとき
			if p == KICKOFFPLYR then
				for i in Players() do
					i:play_sound("alarm",0)
				end
				INTERRUPT, KICKOFF, KICKOFFPLYR = false, false, nil
				WAITTIME = 0
			end
			
			KICKEDPLYR = p
			B_ISGND = false
			B_ANGL = p.yaw
			
			if stop then
				B_VELO, B_GRAV = 0, math.min(0, B_GRAV)
			else
				i = math.rad(p.yaw)
				pdeg = Vec2D.new(math.cos(i), math.sin(i))
				pdeg = Vec2D.norm(pdeg)
				blds = Vec2D.new(B_XPOS - p.x, B_YPOS - p.y)
				blds = Vec2D.norm(blds)
				if Vec2D.dot(pdeg, blds) > 0 then								----前方にボールがあるとき
					i = math.rad(p.yaw)
				else															----後方にボールがあるとき
					i = math.rad(180 + p.yaw)
				end
				B_VELO = B_VELO + pw
				B_GRAV = B_GRAV + math.sin(math.rad(p.pitch)) * pw
			end
			
			if p.polygon.type == "zone border" then								----GKエリアでボールに触れたとき
				if (p.team == TEAM_A and p.y < 0) or (p.team == TEAM_B and p.y > 0) then								---- 敵陣のGKエリア
					B_XLND, B_YLND, B_ZLND, B_PLND = B_XPOS, B_YPOS, B_ZPOS, B_PPOS
					OFFSIDEGK = true
					INTERRUPT = true
				elseif p._RELOADTIME < 0 and ((p.team == TEAM_A and p.y > 0) or (p.team == TEAM_B and p.y < 0)) then	---- 自軍のGKエリア
					B_VELO, B_GRAV = 0, 0
					BALL:play_sound("got ball",0)
					CATCHEDPLYR = p
				end
			end
			
		end
	end
	p._SHOTMODE = 0
end


--================ ジャンプ・ダッシュ処理 ================--


function JUMPING(p)
	local x, y, k = 0, 0, 0
	
	if p.external_velocity.z == 0 and p.action_flags.microphone_button then ---- ジャンプキーが押されたら
		p.external_velocity.z = CNST_jumppwr
		p.monster:play_sound("flickta projectile lava flyby",1)
	end
	
	if BALLOUTSIDE == false or (BALLOUTSIDE == true and CATCHEDPLYR ~= P) then ---- スローワー以外なら
		if p.oxygen > CNST_oxygendrain and p.action_flags.action_trigger then ---- 酸素が残ってて、ダッシュキーが押されたら
			x, y  = p.internal_velocity.forward, p.internal_velocity.perpendicular
			k = math.rad(p.yaw) + math.atan2(y, x)
			p.external_velocity.x = math.max(-CNST_dashspdmax, math.min(CNST_dashspdmax, p.external_velocity.x + math.cos(k) * CNST_dashspd))
			p.external_velocity.y = math.max(-CNST_dashspdmax, math.min(CNST_dashspdmax, p.external_velocity.y + math.sin(k) * CNST_dashspd))
			p.monster:play_sound("rocket flyby", 1)
			p.oxygen = math.max(0, p.oxygen - CNST_oxygendrain)
		end
	end
	
end


--================ プレイヤー処理 ================--


function PLAYEREVENT()
	local teamstr, redname, bluename = "", "", ""
	local redpts, bluepts, i, n = 0, 0, 0, 0
	local newd, oldd = {}, {}
	
	for p in Players() do													----プレイヤー名の一覧作成、チームポイントの集計
		if ISSINGLEGAME == false then
			if (p.team == TEAM_A) then
				redpts = redpts + p.points
				redname = redname .. p.name .. "  "
			else
				bluepts = bluepts + p.points
				bluename = bluename .. p.name .. "  "
			end
		else
			redpts, bluepts = 0, 0
		end
	end
		
	for p in Players() do
		if p == CATCHEDPLYR and BALLOUTSIDE then
			p:position(B_XLND, B_YLND, p.z, B_PLND)
			p.external_velocity.x, p.external_velocity.y = 0, 0
		end
		
		if p.oxygen < CNST_oxygendrain then
			p.action_flags.right_trigger = false
		end
		
		if (p._RELOADTIME < 0) then
			if p.action_flags.left_trigger then			----ふつうのシュート
				p._SHOTMODE = 1
				p._RELOADTIME = 12
			elseif p.action_flags.right_trigger then	----惑星に穴をあけるくらいの強烈シュート（酸素必要）
				p._SHOTMODE = 2
				p._RELOADTIME = 25
				p.oxygen = math.min(10800, p.oxygen - CNST_oxygendrain)
			end
		end
		
		if (p._TXTRELEASE == 0) then
			p.overlays[0].text = " "
		end
		
		if (p.team == TEAM_A) then
			teamstr = "RED"
			p.overlays[1].color = "red"
			p.overlays[1].text = "                            -        TEAM : " .. teamstr .. "    FRIENDS : " .. redname
		else
			teamstr = "BLUE"
			p.overlays[1].color = "blue"
			p.overlays[1].text = "                            -        TEAM : " .. teamstr .. "    FRIENDS : " .. bluename
		end
		
		p.action_flags.cycle_weapons_forward = false
		p.action_flags.cycle_weapons_backward = false
		p.overlays[2].text = "           "..redpts
		p.overlays[2].color = TEAM_A
		p.overlays[3].text = ""..bluepts
		p.overlays[3].color = TEAM_B
		p.compass.x, p.compass.y = BALL.x, BALL.y
		p.oxygen = math.min(10800,p.oxygen + CNST_oxygenrecover)
		
		i = math.rad(p._OLDYAW)
		n = math.rad(p.yaw)
		newd = Vec2D.new(math.cos(i), math.sin(i))
		newd = Vec2D.norm(newd)
		newd = Vec2D.perp(newd)
		oldd = Vec2D.new(math.cos(n), math.sin(n))
		oldd = Vec2D.norm(oldd)
		p._ROTATEVELO = Vec2D.dot(newd, oldd) * CNST_rotatevelo
		
		p._OLDYAW = p.yaw
		p._TXTRELEASE = p._TXTRELEASE - 1
		p._RELOADTIME = p._RELOADTIME - 1
		p._OLDX, p._OLDY, p._OLDZ, p._OLDP = p.x, p.y, p.z, p.polygon
	end
end


--================ ゲーム開始のカウントダウン ================--


function COUNTDOWN()
	for p in Players() do
		if WAITTIME > 1 then
			if WAITTIME % 30 == 0 then
				p.overlays[0].text, p.overlays[0].color = "Are you ready!? ... " .. math.floor(WAITTIME / 30), 0
				p:play_sound("computer login",2)
			end
		else
			p.overlays[0].text, p.overlays[0].color = "<< GAME START >>", 0
			p:play_sound("alarm",0)
			p._TXTRELEASE = 80
			INTERRUPT, FIRST = false, false
		end
		p:position(p._STX, p._STY, p.z, p._STP)
		p.external_velocity.x, p.external_velocity.y = 0, 0
	end
	WAITTIME = WAITTIME - 1
end


--================ 各種ゲーム中断処理 ================--


function WAITING(time, mode)
	
	if WAITTIME == 0 then
		for p in Players() do
			if mode == 0 then
				p.overlays[0].text, p.overlays[0].color = "<< THROW IN >>", 0
				p._TXTRELEASE = 55
				p:play_sound("oxygen warning", 1)
			elseif mode == 1 then
				p.overlays[0].text, p.overlays[0].color = "<< OFFSIDE! (Touch ball in GK area) >>", 0
				p._TXTRELEASE = 55
				p:play_sound("oxygen warning", 1)
			end
		end
	end
	
	if WAITTIME > time then
		
		for p in Players() do
			p._SHOTMODE = 0
		end
		
		if mode == 0 then			----タッチライン越え
		
			CATCHEDPLYR = FINDNEARESTPLYR()
			CATCHEDPLYR:fade_screen("white")
			CATCHEDPLYR:play_sound("teleport in")
			CATCHEDPLYR:position(B_XLND, B_YLND, B_ZLND, B_PLND)
			CATCHEDPLYR.yaw = FIXDEG(180 + math.deg(math.atan2(CATCHEDPLYR.y, CATCHEDPLYR.x)))
			CATCHEDPLYR.external_velocity.x, CATCHEDPLYR.external_velocity.y, CATCHEDPLYR.external_velocity.z = 0, 0, 0
			B_VELO, B_GRAV = 0, 0
			INTERRUPT = false
			WAITTIME = 0
			
		elseif mode == 1 then		----オフサイド（GKエリアでボール触った）
		
			CATCHEDPLYR = FINDNEARESTPLYR()
			CATCHEDPLYR:fade_screen("white")
			CATCHEDPLYR:play_sound("teleport in")
			CATCHEDPLYR:position(B_XLND, B_YLND, B_ZLND, B_PLND)
			CATCHEDPLYR.yaw = FIXDEG(180 + math.deg(math.atan2(CATCHEDPLYR.y, CATCHEDPLYR.x)))
			CATCHEDPLYR.external_velocity.x, CATCHEDPLYR.external_velocity.y, CATCHEDPLYR.external_velocity.z = 0, 0, 0
			B_VELO, B_GRAV = 0, 0
			OFFSIDEGK = false
			INTERRUPT = false
			WAITTIME = 0
			
		elseif mode == 2 then		----ゴール
		
			RESETFIELD()
			KICKOFFPLYR = FINDNEARESTPLYR()
			KICKOFF = true
			
		elseif mode == 3 then		----相手チームのキックオフ待ち
		
			for p in Players() do
				p._TXTRELEASE = 5
				if KICKOFFPLYR ~= p then
					p:position(p._STX, p._STY, p.z, p._STP)
					p.external_velocity.x, p.external_velocity.y = 0, 0
					p.overlays[0].text, p.overlays[0].color = "Waiting for Kick off...", 0
				else
					p.overlays[0].text, p.overlays[0].color = "You can Kick off.", 0
					SHOOTING(p)
				end
			end
			
		end
		
	else
		WAITTIME = WAITTIME + 1
	end
end


--================ プレイヤー衝突処理 ================--


function PLAYERCOLLISION()
	local x1, y1, z1, x2, y2, z2, d1, d2
	local ispd, nspd = 0, 0
	for i in Players() do
		for n in Players() do
			if i ~= n then
				if i._COLLISIONED == false and n._COLLISIONED == false then
					local dist = (i.x - n.x) ^ 2 + (i.y - n.y) ^ 2 + (i.z - n.z) ^ 2 
				 	if (dist < 1.000) then 
						x1, y1, z1 = (i.x - n.x), (i.y - n.y), (i.z - n.z)
						x2, y2, z2 = (n.x - i.x), (n.y - i.y), (n.z - i.z)
						d1 = (x1 ^ 2 + y1 ^ 2 + z1 ^ 2) ^ 0.5
						d2 = (x2 ^ 2 + y2 ^ 2 + z2 ^ 2) ^ 0.5
						ispd = ((i.x - i._OLDX) ^ 2 + (i.y - i._OLDY) ^ 2) ^ 0.5 * 4		----自分の加速度検出
						nspd = ((n.x - n._OLDX) ^ 2 + (n.y - n._OLDY) ^ 2) ^ 0.5 * 4		----相手の加速度検出
						n.external_velocity.x = n.external_velocity.x + (x2 / d2) * ispd
						n.external_velocity.y = n.external_velocity.y + (y2 / d2) * ispd
						n.external_velocity.z = n.external_velocity.z + (z2 / d2) * ispd
						i.external_velocity.x = i.external_velocity.x + (x1 / d1) * nspd
						i.external_velocity.y = i.external_velocity.y + (y1 / d1) * nspd
						i.external_velocity.z = i.external_velocity.z + (z1 / d1) * nspd
					end
				end
			end
		end
	end
	for p in Players() do
		p._COLLISIONED = false
	end
end


--[[
•••••••••••••••••••••••••••••••••••••••••••••••••••••••••••••••
•••••••••••••••••••••• AlephOne 内部イベント •••••••••••••••••••••
•••••••••••••••••••••••••••••••••••••••••••••••••••••••••••••••
]]


--================ マップ読み込み直前イベント ================--


function Triggers.init()
	local playerlist = {}
	local music = ""
	local coll, idx, i, n, a, b = 0, 0, 0, 0, 0, 0
	local limitteam = math.floor(#Players / 2)
	local autoselect, t = false, false
	local g = nil
	
	FIRST, INTERRUPT = true, true
	WAITTIME = 90
	
	for i in Sides() do													---- 有効壁定義
		if i.polygon.type ~= "goal" then
			table.insert(VALIDSIDES, i)
		end
	end
	
	for m in Monsters() do												---- ボール定義
		if m.type == "minor tick" then
			BALL = m
			B_XINT, B_YINT, B_ZINT, B_PINT = m.x, m.y, m.z + 2, m.polygon
			break
		end
	end
	
	if #Players == 1 then ISSINGLEGAME = true end
	
	for p in Players() do												----誰か１人でも赤、青以外のチームがいたら、自動割当モードへ変更
		if p.team ~= TEAM_A and p.team ~= TEAM_B then autoselect = true end
	end
	
	for p in Players() do												----赤または青チームメンバーが４人以上ならば、自動割当モードへ変更
		if p.team == TEAM_A then a = a + 1 end
		if p.team == TEAM_B then b = b + 1 end
		if a == 5 or b == 5 then autoselect = true end
	end
	
	if a == 0 or b == 0 then autoselect = true end						----赤または青チームメンバーが誰もいなかったら、自動割当モードへ変更
	
	if autoselect then
		for i = 1, #Players do
			playerlist[i] = Players[i - 1]
		end
		while #playerlist > 0 do
			i = math.floor(Game.global_random(#playerlist)) + 1
			if t then
				playerlist[i].team = TEAM_A
			else
				playerlist[i].team = TEAM_B
			end
			t = not t
			table.remove(playerlist,i)
		end
	end
	
	for p in Players() do												----各プレイヤーのポジション設定
		for OBJ in Scenery() do
			if (p.team == TEAM_A and OBJ.y > 0) or (p.team == TEAM_B and OBJ.y < 0) then
				p:position(OBJ.x,OBJ.y,OBJ.z,OBJ.polygon)
				p.compass.beacon, p.compass.lua = true, true
				p._STX, p._STY, p._STZ, p._STP = OBJ.x, OBJ.y, OBJ.z, OBJ.polygon
				OBJ:delete()
				break
			end
		end
	end
	
	for OBJ in Scenery() do
		OBJ:delete()
	end
	
	
	for w in Polygons() do												----ゴールエリアにチームカラーを塗り付ける 
		if w.type == "hill" then
		
			if w.y > 0 then												----REDGOAL
				coll, idx = 18, 12
			elseif w.y < 0 then											----BLUEGOAL
				coll, idx = 17, 19
			end
			
			w.floor.collection, w.floor.texture_index = coll, idx
			w.ceiling.collection, w.ceiling.texture_index = coll, idx
			
			for s in w:sides() do
				s._ISGOALWALL = true
				s.primary.collection, s.primary.texture_index = coll, idx
				s.secondary.collection, s.secondary.texture_index = coll, idx
			end
			
		end
	end
	
	i = math.floor(Game.global_random(12))								---- たのしい音楽の選択
		if i == 0 then music = "Musics/track000.mp3"
	elseif i == 1 then music = "Musics/track001.mp3"
	elseif i == 2 then music = "Musics/track002.mp3"
	elseif i == 3 then music = "Musics/track003.mp3"
	elseif i == 4 then music = "Musics/track004.mp3"
	elseif i == 5 then music = "Musics/track005.mp3"
	elseif i == 6 then music = "Musics/track006.mp3"
	elseif i == 7 then music = "Musics/track007.mp3"
	elseif i == 8 then music = "Musics/track008.mp3"
	elseif i == 9 then music = "Musics/track009.mp3"
	elseif i ==10 then music = "Musics/track010.mp3"
	elseif i ==11 then music = "Musics/track011.mp3"
	end
	
	BALL.active = true
	Music.play(music, music, music, music, music) ---- 5回再生
	RESETFIELD()
end


--================ 毎フレーム実行イベント ================--


function Triggers.idle()
	if INTERRUPT == false then						----ゲーム中断がなければ通常動作
		for p in Players() do
			JUMPING(p)
			SHOOTING(p)
		end
		SOCCEREVENT()
	else											----中断があった場合
		if FIRST then
			COUNTDOWN()
		else
			if BALLOUTSIDE then 	WAITING(30, 0)
			elseif OFFSIDEGK then 	WAITING(30, 1)
			elseif GOALED then 		WAITING(90, 2)
			elseif KICKOFF then 	WAITING(-1, 3) end
		end
	end
	
	if ISSINGLEGAME == false then PLAYERCOLLISION() end
	PLAYEREVENT()
	BALLBOUNCE()
end
